// Copyright 2005 Ben Hutchings <ben@decadentplace.org.uk>.
// See the file "COPYING" for licence details.

#ifndef INC_AUTO_TEMP_FILE_HPP
#define INC_AUTO_TEMP_FILE_HPP

#include "auto_handle.hpp"

#include <string>

#include <unistd.h>

struct auto_temp_file_closer
{
    void operator()(const std::string & name) const
	{
	    if (!name.empty())
		unlink(name.c_str());
	}
};
struct auto_temp_file_factory
{
    std::string operator()() const { return std::string(); }
};
typedef auto_handle<std::string, auto_temp_file_closer, auto_temp_file_factory>
    auto_temp_file;

#endif // !INC_AUTO_TEMP_FILE_HPP
