// Copyright 2005 Ben Hutchings <ben@decadentplace.org.uk>.
// See the file "COPYING" for licence details.

#include "childiterator.hpp"

#include <cassert>

#include "xpcom_support.hpp"

using xpcom_support::check;

ChildIterator::ChildIterator()
	: node_(0)
{}

ChildIterator::ChildIterator(nsIDOMNode * node)
{
    check(node->GetFirstChild(&node_));
}

ChildIterator::~ChildIterator()
{
    if (node_)
	node_->Release();
}

already_AddRefed<nsIDOMNode> ChildIterator::operator*() const
{
    assert(node_);
    node_->AddRef();
    return node_;
}

ChildIterator & ChildIterator::operator++()
{
    nsIDOMNode * next;
    check(node_->GetNextSibling(&next));
    node_->Release();
    node_ = next;
    return *this;
}

bool ChildIterator::operator==(const ChildIterator & other) const
{
    return node_ == other.node_;
}
