// Copyright 2005 Ben Hutchings <ben@decadentplace.org.uk>.
// See the file "COPYING" for licence details.

#ifndef INC_CHILDITERATOR_HPP
#define INC_CHILDITERATOR_HPP

#include <iterator>

#include <nsCOMPtr.h>
#include <nsIDOMNode.h>

class ChildIterator
    : public std::iterator<std::input_iterator_tag, nsCOMPtr<nsIDOMNode>,
			   void, void, void>
{
public:
    ChildIterator();
    explicit ChildIterator(nsIDOMNode * node);
    ~ChildIterator();

    already_AddRefed<nsIDOMNode> operator*() const;
    ChildIterator & operator++();
    bool operator==(const ChildIterator &) const;
    bool operator!=(const ChildIterator & other) const
	{
	    return !(*this == other);
	}

private:
    nsIDOMNode * node_;
};

#endif // !INC_CHILDITERATOR_HPP
