#ifndef INC_DVD_HPP
#define INC_DVD_HPP

namespace dvd
{
    // Maximum number of buttons in a menu.
    // TODO: Check whether this is a dvdauthor limitation or part of the
    // DVD Video spec.
    const int menu_buttons_max = 36;

    // Number of colours allowed in each button.
    // Buttons can change colour when they are selected.
    const int button_n_colours = 4;

    // DVD virtual machine register size.
    const int reg_bits = 16;

    // Number by which button numbers must be multiplied when stored in
    // system register 8.
    const int reg_s8_button_mult = 0x400;
}

#endif // !INC_DVD_HPP
