// Copyright 2005 Ben Hutchings <ben@decadentplace.org.uk>.
// See the file "COPYING" for licence details.

#ifndef INC_FRAMEBUFFER_HPP
#define INC_FRAMEBUFFER_HPP

#include <string>

#include "auto_proc.hpp"
#include "auto_temp_file.hpp"

// Run Xvfb with a frame buffer of the given dimensions.
class FrameBuffer
{
public:
    FrameBuffer(int width, int height, int depth);
    std::string get_x_authority() const;
    std::string get_x_display() const;

private:
    int display_num_;
    auto_temp_file auth_file_;
    auto_kill_proc server_proc_;
};

#endif // !INC_FRAMEBUFFER_HPP
