// Copyright 2005 Ben Hutchings <ben@decadentplace.org.uk>.
// See the file "COPYING" for licence details.

#include "linkiterator.hpp"

#include <cassert>

#include <nsIDOMHTMLCollection.h>
#include <nsIDOMHTMLDocument.h>

LinkIterator::LinkIterator()
{}

LinkIterator::LinkIterator(nsIDOMDocument * document)
{
    nsCOMPtr<nsIDOMHTMLDocument> htmlDoc(do_QueryInterface(document));
    if (!htmlDoc)
	return;

    htmlDoc->GetLinks(getter_AddRefs(collection_));
    assert(collection_);

    index_ = 0;
    length_ = 0;
    collection_->GetLength(&length_);
    if (length_ == 0)
	collection_ = 0;
}

already_AddRefed<nsIDOMNode> LinkIterator::operator*() const
{
    assert(collection_);
    nsIDOMNode * result = 0;
    collection_->Item(index_, &result);
    assert(result);
    return dont_AddRef(result);
}

LinkIterator & LinkIterator::operator++()
{
    assert(collection_);
    ++index_;
    if (index_ == length_)
	collection_ = 0;
    return *this;
}

bool LinkIterator::operator==(const LinkIterator & other) const
{
    return (collection_ == other.collection_
	    && (!collection_ || index_ == other.index_));
}
