// Copyright 2005 Ben Hutchings <ben@decadentplace.org.uk>.
// See the file "COPYING" for licence details.

#ifndef INC_LINKITERATOR_HPP
#define INC_LINKITERATOR_HPP

#include <iterator>

#include <nsCOMPtr.h>
#include <nsIDOMHTMLCollection.h>
#include <nsIDOMNode.h>

class nsIDOMDocument;

class LinkIterator
    : public std::iterator<std::input_iterator_tag, nsCOMPtr<nsIDOMNode>,
			   void, void, void>
{
public:
    LinkIterator();
    explicit LinkIterator(nsIDOMDocument * document);

    already_AddRefed<nsIDOMNode> operator*() const;
    LinkIterator & operator++();
    bool operator==(const LinkIterator &) const;
    bool operator!=(const LinkIterator & other) const
	{
	    return !(*this == other);
	}

private:
    nsCOMPtr<nsIDOMHTMLCollection> collection_;
    unsigned int index_, length_;
};

#endif // !INC_LINKITERATOR_HPP
