// Copyright 2005 Ben Hutchings <ben@decadentplace.org.uk>.
// See the file "COPYING" for licence details.

#include "stylesheets.hpp"

#include <nsContentCID.h>
#include <nsICSSLoader.h>
#include <nsICSSStyleSheet.h>
#include <nsIPresShell.h>
#include <nsIServiceManagerUtils.h>
#include <nsIURI.h>
#include <nsNetUtil.h>

#include "xpcom_support.hpp"

using xpcom_support::check;

// Load a CSS from an (absolute) URI.
// TODO: Support loading from an absolute, or better, relative filename.
already_AddRefed<nsIStyleSheet> load_css(const char * uri)
{
    nsCOMPtr<nsICSSLoader> css_loader;
    static const nsCID css_loader_cid = NS_CSS_LOADER_CID;
    check(CallGetService<nsICSSLoader>(css_loader_cid,
				       getter_AddRefs(css_loader)));

    nsCOMPtr<nsIURI> style_sheet_uri;
    check(NS_NewURI(getter_AddRefs(style_sheet_uri), nsCString(uri)));

    nsICSSStyleSheet * style_sheet;
    check(css_loader->LoadAgentSheet(style_sheet_uri, &style_sheet));
    return style_sheet;
}

// Apply a style-sheet to a given presentation shell as the top-priority
// agent style-sheet and disable the preferences-derived style rules.
void apply_style_sheet(nsIStyleSheet * style_sheet, nsIPresShell * pres_shell)
{
    nsCOMArray<nsIStyleSheet> style_sheets;
    check(pres_shell->GetAgentStyleSheets(style_sheets));
    check(style_sheets.InsertObjectAt(style_sheet, 0));
    check(pres_shell->SetAgentStyleSheets(style_sheets));

    check(pres_shell->EnablePrefStyleRules(false));

    // Update the display
    check(pres_shell->ReconstructStyleData());
    check(pres_shell->FlushPendingNotifications(true));
}

