// Copyright 2005 Ben Hutchings <ben@decadentplace.org.uk>.
// See the file "COPYING" for licence details.

#ifndef INC_STYLESHEETS_HPP
#define INC_STYLESHEETS_HPP

#include <nsCOMPtr.h>
#include <nsIStyleSheet.h>

class nsIPresShell;

// Load a CSS from an (absolute) URI.
// TODO: Support loading from an absolute, or better, relative filename.
already_AddRefed<nsIStyleSheet> load_css(const char * uri);

// Apply a style-sheet to a given presentation shell as the top-priority
// agent style-sheet and disable the preferences-derived style rules.
void apply_style_sheet(nsIStyleSheet *, nsIPresShell *);

#endif // !INC_STYLESHEETS_HPP
